<?php

namespace App\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class UserTyping implements ShouldBroadcastNow
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public function __construct(
        public int $userId,
        public string $userName,
        public ?int $coachId = null,
        public ?int $clientId = null,
        public ?int $adminId = null
    ) {}

    public function broadcastOn(): array
    {
        $channels = [];

        // Admin-Coach chat
        if ($this->adminId && $this->coachId) {
            $channels[] = new PrivateChannel("admin-chat.{$this->adminId}.{$this->coachId}");
        }
        // Coach-Client chat
        elseif ($this->coachId && $this->clientId) {
            $channels[] = new PrivateChannel("chat.{$this->coachId}.{$this->clientId}");
        }

        return $channels;
    }

    public function broadcastAs(): string
    {
        return 'user.typing';
    }

    public function broadcastWith(): array
    {
        return [
            'user_id' => $this->userId,
            'user_name' => $this->userName,
        ];
    }
}
