<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Traits\ChatTrait;
use App\Models\User;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Inertia\Inertia;
use Inertia\Response;

class ChatController extends Controller
{
    use ChatTrait;

    /**
     * Display the chat interface for administration.
     * Coaches are the primary contact for admins.
     */
    public function index(Request $request): Response
    {
        $coaches = User::coaches()->where('status', 'active')->get()->map(function ($coach) {
            return [
                'id' => $coach->id,
                'name' => $coach->name,
                'email' => $coach->email,
                'avatar' => $coach->avatar,
                'avatar_url' => $coach->avatar_url,
                'has_unread' => $this->hasUnreadMessages($coach->id, auth()->id()),
            ];
        });

        $selectedCoachId = $request->query('coach_id', $coaches->first()['id'] ?? null);
        $selectedCoach = null;

        if ($selectedCoachId) {
            $coach = User::find($selectedCoachId);
            if ($coach) {
                $selectedCoach = [
                    'id' => $coach->id,
                    'name' => $coach->name,
                    'email' => $coach->email,
                    'avatar' => $coach->avatar,
                    'avatar_url' => $coach->avatar_url,
                ];
            }
        }

        $messages = [];
        if ($selectedCoach) {
            $messages = $this->getConversation(auth()->id(), $selectedCoach['id']);
            $this->markMessagesAsRead($selectedCoach['id'], auth()->id());
        }

        return Inertia::render('Admin/Chat/Index', [
            'coaches' => $coaches,
            'selectedCoach' => $selectedCoach,
            'messages' => $messages,
        ]);
    }

    /**
     * Store a new message.
     */
    public function store(Request $request): RedirectResponse
    {
        $validated = $request->validate([
            'receiver_id' => 'required|exists:users,id',
            'content' => 'required|string|max:2000',
        ]);

        $this->createAndNotifyMessage(
            auth()->user(),
            $validated['receiver_id'],
            $validated['content']
        );

        return back();
    }
}

