<?php

namespace App\Http\Controllers;

use App\Models\Setting;
use Illuminate\Http\JsonResponse;

class ManifestController extends Controller
{
    /**
     * Generate the dynamic PWA manifest.
     */
    public function index(): JsonResponse
    {
        $name = Setting::get('pwa_name', config('app.name', 'CoachPro'));
        $shortName = Setting::get('pwa_short_name', 'CoachPro');
        $description = Setting::get('pwa_description', 'Plataforma para Entrenadores');
        // Default colors match Welcome page theme (neon green primary, dark background)
        $themeColor = Setting::get('pwa_theme_color', '#39FF14');
        $backgroundColor = Setting::get('pwa_background_color', '#0A0A0A');
        $display = Setting::get('pwa_display', 'standalone');

        $icons = [];
        
        // Add custom icons if they exist, otherwise use defaults
        $icon192 = Setting::get('pwa_icon_192');
        $icon512 = Setting::get('pwa_icon_512');

        if ($icon192) {
            $icons[] = [
                "src" => "/storage/" . $icon192,
                "sizes" => "192x192",
                "type" => "image/png",
                "purpose" => "any"
            ];
            $icons[] = [
                "src" => "/storage/" . $icon192,
                "sizes" => "192x192",
                "type" => "image/png",
                "purpose" => "maskable"
            ];
        } else {
            $icons[] = [
                "src" => "/icons/icon-192x192.svg",
                "sizes" => "192x192",
                "type" => "image/svg+xml",
                "purpose" => "any"
            ];
        }

        if ($icon512) {
            $icons[] = [
                "src" => "/storage/" . $icon512,
                "sizes" => "512x512",
                "type" => "image/png",
                "purpose" => "any"
            ];
        } else {
            $icons[] = [
                "src" => "/icons/icon-512x512.svg",
                "sizes" => "512x512",
                "type" => "image/svg+xml",
                "purpose" => "any"
            ];
        }

        $manifest = [
            "name" => $name,
            "short_name" => $shortName,
            "description" => $description,
            "theme_color" => $themeColor,
            "background_color" => $backgroundColor,
            "display" => $display,
            "orientation" => "portrait-primary",
            "scope" => "/",
            "start_url" => "/",
            "lang" => "es",
            "categories" => ["fitness", "health", "business"],
            "icons" => $icons,
            "shortcuts" => [
                [
                    "name" => "Dashboard",
                    "short_name" => "Dashboard",
                    "description" => "Ver panel principal",
                    "url" => "/dashboard",
                    "icons" => [["src" => "/icons/icon-96x96.svg", "sizes" => "96x96"]]
                ]
            ]
        ];

        return response()->json($manifest)
            ->header('Content-Type', 'application/manifest+json');
    }
}
