<?php

namespace App\Http\Controllers;

use App\Models\Setting;
use Illuminate\Http\RedirectResponse;
use Inertia\Inertia;
use Inertia\Response;

class PageController extends Controller
{
    /**
     * Page titles mapping (contact removed - has dedicated page).
     */
    protected array $pageTitles = [
        'about' => 'Quiénes Somos',
        'terms' => 'Términos y Condiciones',
        'privacy' => 'Política de Privacidad',
        'cookies' => 'Política de Cookies',
        'refund' => 'Política de Reembolso',
        'faq' => 'Preguntas Frecuentes',
    ];

    /**
     * Display the specified page.
     */
    public function show(string $slug): Response|RedirectResponse
    {
        // Redirect contact to dedicated contact page
        if ($slug === 'contact') {
            return redirect()->route('contact');
        }

        $content = Setting::get("page_{$slug}", $this->getDefaultContent($slug));
        $title = $this->pageTitles[$slug] ?? ucfirst($slug);

        return Inertia::render('Pages/Show', [
            'slug' => $slug,
            'title' => $title,
            'content' => $content,
        ]);
    }

    /**
     * Get default content for a page.
     */
    private function getDefaultContent(string $slug): string
    {
        $defaults = [
            'about' => '<h1>Sobre CoachPro</h1>
                <p>CoachPro es la plataforma líder para entrenadores personales que desean gestionar sus clientes de manera profesional.</p>
                <h2>Nuestra Misión</h2>
                <p>Facilitar la gestión de clientes, rutinas y planes de alimentación para que los entrenadores puedan enfocarse en lo que mejor saben hacer: entrenar.</p>',
            
            'terms' => '<h1>Términos y Condiciones</h1>
                <p>Al utilizar CoachPro, aceptas los siguientes términos y condiciones:</p>
                <h2>1. Uso del Servicio</h2>
                <p>El servicio está destinado a entrenadores personales profesionales...</p>
                <h2>2. Cuenta de Usuario</h2>
                <p>Eres responsable de mantener la confidencialidad de tu cuenta...</p>',
            
            'privacy' => '<h1>Política de Privacidad</h1>
                <p>Tu privacidad es importante para nosotros. Esta política describe cómo recopilamos y utilizamos tus datos.</p>
                <h2>Datos que Recopilamos</h2>
                <p>Recopilamos información que nos proporcionas directamente...</p>',
            
            'cookies' => '<h1>Política de Cookies</h1>
                <p>Este sitio utiliza cookies para mejorar tu experiencia.</p>
                <h2>¿Qué son las Cookies?</h2>
                <p>Las cookies son pequeños archivos de texto que se almacenan en tu dispositivo...</p>
                <h2>Cookies que Utilizamos</h2>
                <ul>
                    <li><strong>Cookies esenciales:</strong> Necesarias para el funcionamiento del sitio</li>
                    <li><strong>Cookies de rendimiento:</strong> Nos ayudan a mejorar el servicio</li>
                </ul>',
            
            'refund' => '<h1>Política de Reembolso</h1>
                <p>Queremos que estés satisfecho con nuestro servicio.</p>
                <h2>Período de Prueba</h2>
                <p>Ofrecemos 7 días de prueba gratuita para que puedas evaluar el servicio.</p>
                <h2>Reembolsos</h2>
                <p>Puedes solicitar un reembolso dentro de los primeros 7 días después de tu primer pago...</p>',
            
            'faq' => '<h1>Preguntas Frecuentes</h1>
                <h2>¿Cómo empiezo?</h2>
                <p>Regístrate y comienza tu prueba gratuita de 7 días. No se requiere tarjeta de crédito.</p>
                <h2>¿Cuántos clientes puedo tener?</h2>
                <p>Depende de tu plan. El plan básico permite hasta 20 clientes, mientras que el Premium es ilimitado.</p>
                <h2>¿Puedo cancelar en cualquier momento?</h2>
                <p>Sí, puedes cancelar tu suscripción en cualquier momento desde tu panel de control.</p>',
        ];

        return $defaults[$slug] ?? '<p>Contenido de la página no disponible.</p>';
    }
}
