<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Admin\LandingController;
use App\Models\DynamicPage;
use App\Models\Post;
use App\Models\Setting;
use Inertia\Inertia;

class WelcomeController extends Controller
{
    /**
     * Display the landing page.
     */
    public function index()
    {
        // Get landing data from admin controller
        $landingData = LandingController::getLandingData();
        
        // Get recent blog posts
        $posts = Post::where('is_published', true)
            ->whereNotNull('published_at')
            ->where('published_at', '<=', now())
            ->orderBy('published_at', 'desc')
            ->take($landingData['settings']['blog_section']['posts_count'] ?? 3)
            ->get(['id', 'title', 'slug', 'excerpt', 'featured_image', 'published_at']);

        // Get system logo as fallback
        $systemLogo = Setting::get('logo');

        // Get dynamic pages for header and footer
        $headerPages = DynamicPage::getHeaderPages();
        $footerPages = DynamicPage::getFooterPages();

        return Inertia::render('Welcome', [
            'settings' => $landingData['settings'],
            'features' => $landingData['features'],
            'testimonials' => $landingData['testimonials'],
            'stats' => $landingData['stats'],
            'socialLinks' => $landingData['socialLinks'],
            'plans' => $landingData['plans'],
            'posts' => $posts,
            'legalPages' => $landingData['legalPages'],
            'systemLogo' => $systemLogo,
            'headerPages' => $headerPages,
            'footerPages' => $footerPages,
        ]);
    }
}
