<?php

namespace App\Notifications;

use App\Models\Setting;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class WorkoutDeleted extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(
        public string $workoutName,
        public string $coachName
    ) {}

    public function via(object $notifiable): array
    {
        return ['database', 'mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        $siteName = Setting::get('site_name', 'CoachPro');

        return (new MailMessage)
            ->subject("🗑️ Rutina Eliminada - {$this->workoutName}")
            ->greeting("Hola {$notifiable->name},")
            ->line("Tu coach {$this->coachName} ha eliminado tu rutina de entrenamiento.")
            ->line('')
            ->line('**Rutina Eliminada:**')
            ->line($this->workoutName)
            ->line('')
            ->line('Si necesitas una nueva rutina o tienes alguna duda, contacta a tu coach.')
            ->action('Ver Mis Rutinas', route('client.workout.index'))
            ->line('Tu coach estará disponible para crear una nueva rutina personalizada cuando lo necesites.')
            ->salutation("Saludos,\nEl equipo de {$siteName}");
    }

    public function toArray(object $notifiable): array
    {
        return [
            'type' => 'workout_deleted',
            'workout_name' => $this->workoutName,
            'coach_name' => $this->coachName,
            'message' => "🗑️ La rutina '{$this->workoutName}' ha sido eliminada por {$this->coachName}",
            'title' => 'Rutina eliminada',
        ];
    }
}
