<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('workouts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('client_id')->constrained()->onDelete('cascade');
            $table->string('name');
            $table->text('description')->nullable();
            $table->json('days')->nullable(); // ['monday', 'wednesday', 'friday']
            $table->integer('duration_weeks')->default(4);
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            
            $table->index('client_id');
        });

        Schema::create('exercises', function (Blueprint $table) {
            $table->id();
            $table->foreignId('workout_id')->constrained()->onDelete('cascade');
            $table->string('name');
            $table->string('muscle_group')->nullable(); // chest, back, legs, shoulders, arms, core
            $table->integer('sets')->default(3);
            $table->string('reps')->default('10'); // Can be "10" or "8-12" or "AMRAP"
            $table->integer('rest_seconds')->default(60);
            $table->text('notes')->nullable();
            $table->string('video_url')->nullable();
            $table->integer('order')->default(0);
            $table->timestamps();
            
            $table->index('workout_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('exercises');
        Schema::dropIfExists('workouts');
    }
};
