<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('paypal_email')->nullable()->after('email');
            $table->string('paypal_me_link')->nullable()->after('paypal_email');
            $table->boolean('paypal_enabled')->default(false)->after('paypal_me_link');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['paypal_email', 'paypal_me_link', 'paypal_enabled']);
        });
    }
};
