<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('coach_landings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('coach_id')->constrained('users')->onDelete('cascade');
            $table->string('slug')->unique();
            $table->boolean('is_active')->default(false);
            
            // Theme & Colors
            $table->string('theme')->default('dark'); // dark, light
            $table->string('primary_color')->default('#EF4444'); // Red accent
            $table->string('secondary_color')->default('#F97316'); // Orange
            
            // Hero Section
            $table->string('hero_title')->nullable();
            $table->string('hero_subtitle')->nullable();
            $table->text('hero_description')->nullable();
            $table->string('hero_image')->nullable();
            $table->string('hero_video_url')->nullable();
            $table->string('hero_badge')->nullable(); // e.g. "+5000 Transformaciones"
            $table->json('hero_benefits')->nullable(); // Array of quick benefits
            $table->string('hero_cta_text')->nullable();
            $table->integer('trial_days')->default(0);
            
            // Target Audience Section ("Esto es para ti si...")
            $table->string('target_title')->nullable();
            $table->json('target_points')->nullable(); // Array of pain points
            $table->string('problem_title')->nullable();
            $table->string('problem_subtitle')->nullable();
            
            // About Coach Section
            $table->string('coach_title')->nullable();
            $table->text('coach_description')->nullable();
            $table->string('coach_image')->nullable();
            $table->string('coach_highlight')->nullable(); // e.g. "5,000+ transformaciones"
            $table->string('coach_tagline')->nullable();
            
            // Plan Features Section
            $table->string('features_title')->nullable();
            $table->string('features_image')->nullable();
            $table->json('plan_features')->nullable(); // Array of features
            
            // Testimonials
            $table->json('testimonials')->nullable(); // Array of {name, role, image, text}
            
            // FAQ Section
            $table->json('faqs')->nullable(); // Array of {question, answer}
            
            // Social Links
            $table->string('instagram_url')->nullable();
            $table->string('facebook_url')->nullable();
            $table->string('tiktok_url')->nullable();
            $table->string('youtube_url')->nullable();
            $table->string('whatsapp_number')->nullable();
            
            // SEO
            $table->string('meta_title')->nullable();
            $table->string('meta_description')->nullable();
            $table->string('og_image')->nullable();
            
            // Analytics
            $table->string('google_analytics_id')->nullable();
            $table->string('facebook_pixel_id')->nullable();
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('coach_landings');
    }
};
