<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('coach_plans', function (Blueprint $table) {
            // Coach section customization
            $table->string('coach_section_title')->nullable()->after('results_images');
            $table->string('coach_section_photo')->nullable()->after('coach_section_title');
            $table->text('coach_section_bio')->nullable()->after('coach_section_photo');
            $table->string('coach_section_tagline')->nullable()->after('coach_section_bio');
            $table->string('coach_section_stats')->nullable()->after('coach_section_tagline'); // e.g., "500+ PERSONAS TRANSFORMADAS"
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('coach_plans', function (Blueprint $table) {
            $table->dropColumn([
                'coach_section_title',
                'coach_section_photo',
                'coach_section_bio',
                'coach_section_tagline',
                'coach_section_stats',
            ]);
        });
    }
};
