<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('coach_plan_purchases', function (Blueprint $table) {
            // Add user_id if not exists (for non-client users)
            if (!Schema::hasColumn('coach_plan_purchases', 'user_id')) {
                $table->foreignId('user_id')->nullable()->after('client_id')->constrained('users')->nullOnDelete();
            }
            
            // Add coach_id for easier querying
            if (!Schema::hasColumn('coach_plan_purchases', 'coach_id')) {
                $table->foreignId('coach_id')->nullable()->after('user_id')->constrained('users')->nullOnDelete();
            }
            
            // Payment method reference
            if (!Schema::hasColumn('coach_plan_purchases', 'payment_method_id')) {
                $table->foreignId('payment_method_id')->nullable()->after('payment_method')->constrained('coach_payment_methods')->nullOnDelete();
            }
            
            // Currency tracking
            if (!Schema::hasColumn('coach_plan_purchases', 'currency')) {
                $table->string('currency', 3)->default('USD')->after('amount');
            }
            
            // Buyer info (for non-registered users)
            if (!Schema::hasColumn('coach_plan_purchases', 'buyer_name')) {
                $table->string('buyer_name')->nullable()->after('currency');
            }
            if (!Schema::hasColumn('coach_plan_purchases', 'buyer_email')) {
                $table->string('buyer_email')->nullable()->after('buyer_name');
            }
            if (!Schema::hasColumn('coach_plan_purchases', 'buyer_phone')) {
                $table->string('buyer_phone', 50)->nullable()->after('buyer_email');
            }
            
            // Tier tracking
            if (!Schema::hasColumn('coach_plan_purchases', 'tier_name')) {
                $table->string('tier_name')->nullable()->after('buyer_phone');
            }
            
            // Receipt tracking
            if (!Schema::hasColumn('coach_plan_purchases', 'receipt_uploaded_at')) {
                $table->timestamp('receipt_uploaded_at')->nullable()->after('paid_at');
            }
            
            // Metadata for additional info
            if (!Schema::hasColumn('coach_plan_purchases', 'metadata')) {
                $table->json('metadata')->nullable()->after('notes');
            }
            
            // Add indexes for common queries
            $table->index(['coach_id', 'status']);
            $table->index(['buyer_email', 'status']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('coach_plan_purchases', function (Blueprint $table) {
            $table->dropIndex(['coach_id', 'status']);
            $table->dropIndex(['buyer_email', 'status']);
            
            $columns = [
                'user_id', 'coach_id', 'payment_method_id', 'currency',
                'buyer_name', 'buyer_email', 'buyer_phone', 'tier_name',
                'receipt_uploaded_at', 'metadata'
            ];
            
            foreach ($columns as $column) {
                if (Schema::hasColumn('coach_plan_purchases', $column)) {
                    $table->dropColumn($column);
                }
            }
        });
    }
};
