<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('photo_comments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('progress_photo_id')->constrained('progress_photos')->onDelete('cascade');
            $table->string('author_name', 100);
            $table->text('comment');
            $table->unsignedInteger('likes_count')->default(0);
            $table->string('ip_address', 45)->nullable();
            $table->timestamps();
            
            $table->index('progress_photo_id');
            $table->index('created_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('photo_comments');
    }
};
