<?php

namespace Database\Seeders;

use App\Models\EmailTemplate;
use Illuminate\Database\Seeder;

class EmailTemplateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $templates = [
            [
                'slug' => 'client-portal-activated',
                'name' => 'Portal de Cliente Activado',
                'subject' => '🎉 ¡Tu portal de cliente está activo! - {{app_name}}',
                'body' => '<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;">
    <div style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 30px; border-radius: 10px 10px 0 0; text-align: center;">
        <h1 style="color: white; margin: 0; font-size: 24px;">¡Bienvenido a tu Portal!</h1>
    </div>
    
    <div style="background: #ffffff; padding: 30px; border: 1px solid #e5e7eb;">
        <p style="font-size: 16px; color: #374151;">¡Hola <strong>{{client_name}}</strong>!</p>
        
        <p style="color: #6b7280;">Tu entrenador <strong>{{coach_name}}</strong> ha activado tu acceso al portal de clientes.</p>
        
        <div style="background: #f3f4f6; padding: 20px; border-radius: 8px; margin: 20px 0;">
            <h3 style="margin: 0 0 15px 0; color: #1f2937;">📧 Tus credenciales de acceso:</h3>
            <p style="margin: 5px 0; color: #374151;"><strong>Email:</strong> {{email}}</p>
            <p style="margin: 5px 0; color: #374151;"><strong>Contraseña:</strong> {{password}}</p>
        </div>
        
        <div style="background: #ecfdf5; padding: 20px; border-radius: 8px; margin: 20px 0; border-left: 4px solid #10b981;">
            <h3 style="margin: 0 0 15px 0; color: #065f46;">✨ ¿Qué puedes hacer en tu portal?</h3>
            <ul style="color: #047857; padding-left: 20px; margin: 0;">
                <li>Ver tus rutinas de entrenamiento personalizadas</li>
                <li>Consultar tu plan de alimentación</li>
                <li>Registrar tu progreso y peso</li>
                <li>Subir fotos de tu transformación</li>
                <li>Comunicarte con tu entrenador</li>
                <li>Descargar tus planes en PDF</li>
            </ul>
        </div>
        
        <div style="text-align: center; margin: 30px 0;">
            <a href="{{login_url}}" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 15px 40px; text-decoration: none; border-radius: 8px; font-weight: bold; display: inline-block;">Acceder a mi Portal</a>
        </div>
        
        <div style="background: #fef3c7; padding: 15px; border-radius: 8px; margin-top: 20px;">
            <p style="margin: 0; color: #92400e; font-size: 14px;">🔒 <strong>Seguridad:</strong> Te recomendamos cambiar tu contraseña después del primer inicio de sesión.</p>
        </div>
    </div>
    
    <div style="background: #f9fafb; padding: 20px; border-radius: 0 0 10px 10px; text-align: center; border: 1px solid #e5e7eb; border-top: none;">
        <p style="margin: 0; color: #9ca3af; font-size: 14px;">¡Éxito en tu transformación!</p>
        <p style="margin: 5px 0 0 0; color: #6b7280; font-weight: bold;">Equipo {{app_name}}</p>
    </div>
</div>',
                'variables' => ['app_name', 'client_name', 'coach_name', 'email', 'password', 'login_url'],
            ],
            [
                'slug' => 'subscription-activated',
                'name' => 'Suscripción Activada',
                'subject' => '✅ Tu suscripción ha sido activada - {{app_name}}',
                'body' => '<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;">
    <div style="background: linear-gradient(135deg, #10b981 0%, #059669 100%); padding: 30px; border-radius: 10px 10px 0 0; text-align: center;">
        <h1 style="color: white; margin: 0; font-size: 24px;">¡Suscripción Activada!</h1>
    </div>
    
    <div style="background: #ffffff; padding: 30px; border: 1px solid #e5e7eb;">
        <p style="font-size: 16px; color: #374151;">¡Hola <strong>{{user_name}}</strong>!</p>
        
        <p style="color: #6b7280;">Tu suscripción al plan <strong>{{plan_name}}</strong> ha sido activada correctamente.</p>
        
        <div style="background: #f3f4f6; padding: 20px; border-radius: 8px; margin: 20px 0;">
            <h3 style="margin: 0 0 15px 0; color: #1f2937;">📋 Detalles de tu suscripción:</h3>
            <p style="margin: 5px 0; color: #374151;"><strong>Plan:</strong> {{plan_name}}</p>
            <p style="margin: 5px 0; color: #374151;"><strong>Fecha de inicio:</strong> {{start_date}}</p>
            <p style="margin: 5px 0; color: #374151;"><strong>Fecha de fin:</strong> {{end_date}}</p>
        </div>
        
        <div style="text-align: center; margin: 30px 0;">
            <a href="{{dashboard_url}}" style="background: linear-gradient(135deg, #10b981 0%, #059669 100%); color: white; padding: 15px 40px; text-decoration: none; border-radius: 8px; font-weight: bold; display: inline-block;">Ir al Dashboard</a>
        </div>
    </div>
    
    <div style="background: #f9fafb; padding: 20px; border-radius: 0 0 10px 10px; text-align: center; border: 1px solid #e5e7eb; border-top: none;">
        <p style="margin: 0; color: #6b7280; font-weight: bold;">Equipo {{app_name}}</p>
    </div>
</div>',
                'variables' => ['app_name', 'user_name', 'plan_name', 'start_date', 'end_date', 'dashboard_url'],
            ],
            [
                'slug' => 'coach-approved',
                'name' => 'Coach Aprobado',
                'subject' => '🎊 ¡Tu cuenta de entrenador ha sido aprobada! - {{app_name}}',
                'body' => '<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;">
    <div style="background: linear-gradient(135deg, #8b5cf6 0%, #6366f1 100%); padding: 30px; border-radius: 10px 10px 0 0; text-align: center;">
        <h1 style="color: white; margin: 0; font-size: 24px;">¡Felicidades! 🎉</h1>
    </div>
    
    <div style="background: #ffffff; padding: 30px; border: 1px solid #e5e7eb;">
        <p style="font-size: 16px; color: #374151;">¡Hola <strong>{{coach_name}}</strong>!</p>
        
        <p style="color: #6b7280;">Nos complace informarte que tu cuenta de entrenador ha sido <strong style="color: #10b981;">aprobada</strong>.</p>
        
        <p style="color: #6b7280;">Ya puedes acceder a todas las funcionalidades de la plataforma y comenzar a gestionar tus clientes.</p>
        
        <div style="background: #f0fdf4; padding: 20px; border-radius: 8px; margin: 20px 0; border-left: 4px solid #10b981;">
            <h3 style="margin: 0 0 15px 0; color: #065f46;">🚀 Próximos pasos:</h3>
            <ol style="color: #047857; padding-left: 20px; margin: 0;">
                <li>Completa tu perfil profesional</li>
                <li>Selecciona un plan de suscripción</li>
                <li>Añade tu primer cliente</li>
                <li>Crea rutinas y planes de alimentación</li>
            </ol>
        </div>
        
        <div style="text-align: center; margin: 30px 0;">
            <a href="{{dashboard_url}}" style="background: linear-gradient(135deg, #8b5cf6 0%, #6366f1 100%); color: white; padding: 15px 40px; text-decoration: none; border-radius: 8px; font-weight: bold; display: inline-block;">Ir a mi Dashboard</a>
        </div>
    </div>
    
    <div style="background: #f9fafb; padding: 20px; border-radius: 0 0 10px 10px; text-align: center; border: 1px solid #e5e7eb; border-top: none;">
        <p style="margin: 0; color: #6b7280; font-weight: bold;">Equipo {{app_name}}</p>
    </div>
</div>',
                'variables' => ['app_name', 'coach_name', 'dashboard_url'],
            ],
            [
                'slug' => 'subscription-expiring',
                'name' => 'Suscripcion por Expirar',
                'subject' => 'Tu suscripcion expira pronto - {{app_name}}',
                'body' => '<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;">
    <div style="background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); padding: 30px; border-radius: 10px 10px 0 0; text-align: center;">
        <h1 style="color: white; margin: 0; font-size: 24px;">Tu suscripcion expira pronto!</h1>
    </div>

    <div style="background: #ffffff; padding: 30px; border: 1px solid #e5e7eb;">
        <p style="font-size: 16px; color: #374151;">Hola <strong>{{user_name}}</strong>!</p>

        <p style="color: #6b7280;">Te informamos que tu suscripcion al plan <strong>{{plan_name}}</strong> expirara el <strong>{{end_date}}</strong>.</p>

        <div style="background: #fef3c7; padding: 20px; border-radius: 8px; margin: 20px 0; border-left: 4px solid #f59e0b;">
            <p style="margin: 0; color: #92400e;">Quedan <strong>{{days_remaining}} dias</strong> para que expire tu suscripcion.</p>
        </div>

        <p style="color: #6b7280;">Para seguir disfrutando de todos los beneficios, renueva tu suscripcion antes de que expire.</p>

        <div style="text-align: center; margin: 30px 0;">
            <a href="{{renew_url}}" style="background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); color: white; padding: 15px 40px; text-decoration: none; border-radius: 8px; font-weight: bold; display: inline-block;">Renovar Ahora</a>
        </div>
    </div>

    <div style="background: #f9fafb; padding: 20px; border-radius: 0 0 10px 10px; text-align: center; border: 1px solid #e5e7eb; border-top: none;">
        <p style="margin: 0; color: #6b7280; font-weight: bold;">Equipo {{app_name}}</p>
    </div>
</div>',
                'variables' => ['app_name', 'user_name', 'plan_name', 'end_date', 'days_remaining', 'renew_url'],
            ],
            [
                'slug' => 'subscription-expired',
                'name' => 'Suscripcion Expirada',
                'subject' => 'Tu suscripcion ha expirado - {{app_name}}',
                'body' => '<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;">
    <div style="background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%); padding: 30px; border-radius: 10px 10px 0 0; text-align: center;">
        <h1 style="color: white; margin: 0; font-size: 24px;">Tu suscripcion ha expirado</h1>
    </div>

    <div style="background: #ffffff; padding: 30px; border: 1px solid #e5e7eb;">
        <p style="font-size: 16px; color: #374151;">Hola <strong>{{user_name}}</strong>,</p>

        <p style="color: #6b7280;">Tu suscripcion al plan <strong>{{plan_name}}</strong> ha expirado.</p>

        <div style="background: #fef2f2; padding: 20px; border-radius: 8px; margin: 20px 0; border-left: 4px solid #ef4444;">
            <p style="margin: 0; color: #991b1b;"><strong>Plan:</strong> {{plan_name}}</p>
            <p style="margin: 5px 0 0 0; color: #991b1b;"><strong>Fecha de expiracion:</strong> {{end_date}}</p>
        </div>

        <div style="background: #fef3c7; padding: 15px; border-radius: 8px; margin: 20px 0;">
            <p style="margin: 0; color: #92400e; font-size: 14px;">Tienes un periodo de gracia de <strong>{{grace_period_days}} dias</strong> para renovar sin perder acceso a tus datos.</p>
        </div>

        <p style="color: #6b7280;">Renueva ahora para continuar gestionando a tus clientes y acceder a todas las funcionalidades.</p>

        <div style="text-align: center; margin: 30px 0;">
            <a href="{{renew_url}}" style="background: linear-gradient(135deg, #10b981 0%, #059669 100%); color: white; padding: 15px 40px; text-decoration: none; border-radius: 8px; font-weight: bold; display: inline-block;">Renovar Suscripcion</a>
        </div>

        <p style="color: #9ca3af; font-size: 13px; text-align: center;">Necesitas ayuda? Contactanos en soporte@coachpro.com</p>
    </div>

    <div style="background: #f9fafb; padding: 20px; border-radius: 0 0 10px 10px; text-align: center; border: 1px solid #e5e7eb; border-top: none;">
        <p style="margin: 0; color: #6b7280; font-weight: bold;">Equipo {{app_name}}</p>
    </div>
</div>',
                'variables' => ['app_name', 'user_name', 'plan_name', 'end_date', 'grace_period_days', 'renew_url'],
            ],
            [
                'slug' => 'subscription-renewed',
                'name' => 'Suscripcion Renovada',
                'subject' => 'Tu suscripcion ha sido renovada - {{app_name}}',
                'body' => '<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;">
    <div style="background: linear-gradient(135deg, #10b981 0%, #059669 100%); padding: 30px; border-radius: 10px 10px 0 0; text-align: center;">
        <h1 style="color: white; margin: 0; font-size: 24px;">Suscripcion Renovada!</h1>
    </div>

    <div style="background: #ffffff; padding: 30px; border: 1px solid #e5e7eb;">
        <p style="font-size: 16px; color: #374151;">Hola <strong>{{user_name}}</strong>!</p>

        <p style="color: #6b7280;">Tu suscripcion al plan <strong>{{plan_name}}</strong> ha sido renovada exitosamente.</p>

        <div style="background: #ecfdf5; padding: 20px; border-radius: 8px; margin: 20px 0; border-left: 4px solid #10b981;">
            <h3 style="margin: 0 0 15px 0; color: #065f46;">Detalles de la renovacion:</h3>
            <p style="margin: 5px 0; color: #047857;"><strong>Plan:</strong> {{plan_name}}</p>
            <p style="margin: 5px 0; color: #047857;"><strong>Monto cobrado:</strong> {{amount_paid}}</p>
            <p style="margin: 5px 0; color: #047857;"><strong>Metodo de pago:</strong> {{payment_method}}</p>
            <p style="margin: 5px 0; color: #047857;"><strong>Nueva fecha de vencimiento:</strong> {{new_end_date}}</p>
        </div>

        <div style="background: #f0fdf4; padding: 15px; border-radius: 8px; margin: 20px 0;">
            <p style="margin: 0; color: #166534; font-size: 14px;">Tu suscripcion esta activa y puedes continuar disfrutando de todas las funcionalidades de CoachPro.</p>
        </div>

        <div style="text-align: center; margin: 30px 0;">
            <a href="{{dashboard_url}}" style="background: linear-gradient(135deg, #10b981 0%, #059669 100%); color: white; padding: 15px 40px; text-decoration: none; border-radius: 8px; font-weight: bold; display: inline-block;">Ir al Dashboard</a>
        </div>
    </div>

    <div style="background: #f9fafb; padding: 20px; border-radius: 0 0 10px 10px; text-align: center; border: 1px solid #e5e7eb; border-top: none;">
        <p style="margin: 0; color: #9ca3af; font-size: 14px;">Gracias por continuar confiando en nosotros</p>
        <p style="margin: 5px 0 0 0; color: #6b7280; font-weight: bold;">Equipo {{app_name}}</p>
    </div>
</div>',
                'variables' => ['app_name', 'user_name', 'plan_name', 'amount_paid', 'payment_method', 'new_end_date', 'dashboard_url'],
            ],
            [
                'slug' => 'welcome',
                'name' => 'Bienvenida',
                'subject' => '👋 ¡Bienvenido a {{app_name}}!',
                'body' => '<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;">
    <div style="background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%); padding: 30px; border-radius: 10px 10px 0 0; text-align: center;">
        <h1 style="color: white; margin: 0; font-size: 24px;">¡Bienvenido! 👋</h1>
    </div>
    
    <div style="background: #ffffff; padding: 30px; border: 1px solid #e5e7eb;">
        <p style="font-size: 16px; color: #374151;">¡Hola <strong>{{user_name}}</strong>!</p>
        
        <p style="color: #6b7280;">Gracias por registrarte en <strong>{{app_name}}</strong>. Estamos emocionados de tenerte con nosotros.</p>
        
        <div style="background: #eff6ff; padding: 20px; border-radius: 8px; margin: 20px 0; border-left: 4px solid #3b82f6;">
            <p style="margin: 0; color: #1e40af;">Tu cuenta está pendiente de aprobación. Te notificaremos cuando esté activa.</p>
        </div>
        
        <div style="text-align: center; margin: 30px 0;">
            <a href="{{login_url}}" style="background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%); color: white; padding: 15px 40px; text-decoration: none; border-radius: 8px; font-weight: bold; display: inline-block;">Iniciar Sesión</a>
        </div>
    </div>
    
    <div style="background: #f9fafb; padding: 20px; border-radius: 0 0 10px 10px; text-align: center; border: 1px solid #e5e7eb; border-top: none;">
        <p style="margin: 0; color: #6b7280; font-weight: bold;">Equipo {{app_name}}</p>
    </div>
</div>',
                'variables' => ['app_name', 'user_name', 'login_url'],
            ],
            // === NEW TEMPLATES ===
            [
                'slug' => 'invoice-generated',
                'name' => 'Factura Generada',
                'subject' => '📄 Nueva Factura {{invoice_number}} - {{app_name}}',
                'body' => '<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;">
    <div style="background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%); padding: 30px; border-radius: 10px 10px 0 0; text-align: center;">
        <h1 style="color: white; margin: 0; font-size: 24px;">📄 Nueva Factura</h1>
    </div>
    
    <div style="background: #ffffff; padding: 30px; border: 1px solid #e5e7eb;">
        <p style="font-size: 16px; color: #374151;">¡Hola <strong>{{user_name}}</strong>!</p>
        
        <p style="color: #6b7280;">Se ha generado una nueva factura para tu suscripción.</p>
        
        <div style="background: #f3f4f6; padding: 20px; border-radius: 8px; margin: 20px 0;">
            <h3 style="margin: 0 0 15px 0; color: #1f2937;">📋 Detalles:</h3>
            <p style="margin: 5px 0; color: #374151;"><strong>Número:</strong> {{invoice_number}}</p>
            <p style="margin: 5px 0; color: #374151;"><strong>Total:</strong> {{invoice_total}}</p>
            <p style="margin: 5px 0; color: #374151;"><strong>Estado:</strong> {{invoice_status}}</p>
        </div>
        
        <div style="text-align: center; margin: 30px 0;">
            <a href="{{invoice_url}}" style="background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%); color: white; padding: 15px 40px; text-decoration: none; border-radius: 8px; font-weight: bold; display: inline-block;">Ver Factura</a>
        </div>
    </div>
    
    <div style="background: #f9fafb; padding: 20px; border-radius: 0 0 10px 10px; text-align: center; border: 1px solid #e5e7eb; border-top: none;">
        <p style="margin: 0; color: #6b7280; font-weight: bold;">Equipo {{app_name}}</p>
        <p style="margin: 5px 0 0 0; color: #9ca3af; font-size: 12px;">Este es un correo automático, por favor no responda.</p>
    </div>
</div>',
                'variables' => ['app_name', 'user_name', 'invoice_number', 'invoice_total', 'invoice_status', 'invoice_url'],
            ],
            [
                'slug' => 'invoice-paid',
                'name' => 'Factura Pagada',
                'subject' => '✅ Pago Confirmado - Factura {{invoice_number}} - {{app_name}}',
                'body' => '<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;">
    <div style="background: linear-gradient(135deg, #10b981 0%, #059669 100%); padding: 30px; border-radius: 10px 10px 0 0; text-align: center;">
        <h1 style="color: white; margin: 0; font-size: 24px;">✅ Pago Confirmado</h1>
    </div>
    
    <div style="background: #ffffff; padding: 30px; border: 1px solid #e5e7eb;">
        <p style="font-size: 16px; color: #374151;">¡Hola <strong>{{user_name}}</strong>!</p>
        
        <p style="color: #6b7280;">¡Gracias por tu pago! Tu factura ha sido marcada como pagada.</p>
        
        <div style="background: #ecfdf5; padding: 20px; border-radius: 8px; margin: 20px 0; border-left: 4px solid #10b981;">
            <h3 style="margin: 0 0 15px 0; color: #065f46;">📋 Detalles del Pago:</h3>
            <p style="margin: 5px 0; color: #047857;"><strong>Factura:</strong> {{invoice_number}}</p>
            <p style="margin: 5px 0; color: #047857;"><strong>Total:</strong> {{invoice_total}}</p>
            <p style="margin: 5px 0; color: #047857;"><strong>Fecha de Pago:</strong> {{payment_date}}</p>
        </div>
        
        <div style="text-align: center; margin: 30px 0;">
            <a href="{{dashboard_url}}" style="background: linear-gradient(135deg, #10b981 0%, #059669 100%); color: white; padding: 15px 40px; text-decoration: none; border-radius: 8px; font-weight: bold; display: inline-block;">Ir al Dashboard</a>
        </div>
    </div>
    
    <div style="background: #f9fafb; padding: 20px; border-radius: 0 0 10px 10px; text-align: center; border: 1px solid #e5e7eb; border-top: none;">
        <p style="margin: 0; color: #6b7280; font-weight: bold;">Equipo {{app_name}}</p>
    </div>
</div>',
                'variables' => ['app_name', 'user_name', 'invoice_number', 'invoice_total', 'payment_date', 'dashboard_url'],
            ],
            [
                'slug' => 'invoice-overdue',
                'name' => 'Factura Vencida',
                'subject' => '⚠️ Factura Vencida {{invoice_number}} - {{app_name}}',
                'body' => '<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;">
    <div style="background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%); padding: 30px; border-radius: 10px 10px 0 0; text-align: center;">
        <h1 style="color: white; margin: 0; font-size: 24px;">⚠️ Factura Vencida</h1>
    </div>
    
    <div style="background: #ffffff; padding: 30px; border: 1px solid #e5e7eb;">
        <p style="font-size: 16px; color: #374151;">Hola <strong>{{user_name}}</strong>,</p>
        
        <p style="color: #6b7280;">Te informamos que tu factura está vencida.</p>
        
        <div style="background: #fef2f2; padding: 20px; border-radius: 8px; margin: 20px 0; border-left: 4px solid #ef4444;">
            <p style="margin: 0; color: #991b1b;"><strong>Factura:</strong> {{invoice_number}}</p>
            <p style="margin: 5px 0; color: #991b1b;"><strong>Total pendiente:</strong> {{invoice_total}}</p>
        </div>
        
        <p style="color: #6b7280;">Por favor, realiza el pago lo antes posible para evitar la suspensión de tu servicio.</p>
        
        <div style="text-align: center; margin: 30px 0;">
            <a href="{{invoice_url}}" style="background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%); color: white; padding: 15px 40px; text-decoration: none; border-radius: 8px; font-weight: bold; display: inline-block;">Pagar Ahora</a>
        </div>
    </div>
    
    <div style="background: #f9fafb; padding: 20px; border-radius: 0 0 10px 10px; text-align: center; border: 1px solid #e5e7eb; border-top: none;">
        <p style="margin: 0; color: #6b7280; font-weight: bold;">Equipo {{app_name}}</p>
    </div>
</div>',
                'variables' => ['app_name', 'user_name', 'invoice_number', 'invoice_total', 'invoice_url'],
            ],
            [
                'slug' => 'payment-reminder',
                'name' => 'Recordatorio de Pago',
                'subject' => '🔔 Recordatorio: Tu pago vence pronto - {{app_name}}',
                'body' => '<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;">
    <div style="background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); padding: 30px; border-radius: 10px 10px 0 0; text-align: center;">
        <h1 style="color: white; margin: 0; font-size: 24px;">🔔 Recordatorio de Pago</h1>
    </div>
    
    <div style="background: #ffffff; padding: 30px; border: 1px solid #e5e7eb;">
        <p style="font-size: 16px; color: #374151;">¡Hola <strong>{{user_name}}</strong>!</p>
        
        <p style="color: #6b7280;">Te recordamos que tu suscripción está próxima a vencer.</p>
        
        <div style="background: #fef3c7; padding: 20px; border-radius: 8px; margin: 20px 0; border-left: 4px solid #f59e0b;">
            <p style="margin: 0; color: #92400e;">⏰ <strong>Quedan {{days_remaining}} días</strong> para que expire tu plan <strong>{{plan_name}}</strong>.</p>
        </div>
        
        <p style="color: #6b7280;">Renueva ahora para mantener acceso a todas las funcionalidades.</p>
        
        <div style="text-align: center; margin: 30px 0;">
            <a href="{{renew_url}}" style="background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); color: white; padding: 15px 40px; text-decoration: none; border-radius: 8px; font-weight: bold; display: inline-block;">Renovar Ahora</a>
        </div>
    </div>
    
    <div style="background: #f9fafb; padding: 20px; border-radius: 0 0 10px 10px; text-align: center; border: 1px solid #e5e7eb; border-top: none;">
        <p style="margin: 0; color: #6b7280; font-weight: bold;">Equipo {{app_name}}</p>
    </div>
</div>',
                'variables' => ['app_name', 'user_name', 'plan_name', 'days_remaining', 'renew_url'],
            ],
            [
                'slug' => 'new-message',
                'name' => 'Nuevo Mensaje',
                'subject' => '💬 Nuevo mensaje de {{sender_name}} - {{app_name}}',
                'body' => '<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;">
    <div style="background: linear-gradient(135deg, #6366f1 0%, #4f46e5 100%); padding: 30px; border-radius: 10px 10px 0 0; text-align: center;">
        <h1 style="color: white; margin: 0; font-size: 24px;">💬 Nuevo Mensaje</h1>
    </div>
    
    <div style="background: #ffffff; padding: 30px; border: 1px solid #e5e7eb;">
        <p style="font-size: 16px; color: #374151;">¡Hola <strong>{{user_name}}</strong>!</p>
        
        <p style="color: #6b7280;">Has recibido un nuevo mensaje de <strong>{{sender_name}}</strong>:</p>
        
        <div style="background: #eef2ff; padding: 20px; border-radius: 8px; margin: 20px 0; border-left: 4px solid #6366f1;">
            <p style="margin: 0; color: #3730a3; font-style: italic;">"{{message_preview}}"</p>
        </div>
        
        <div style="text-align: center; margin: 30px 0;">
            <a href="{{chat_url}}" style="background: linear-gradient(135deg, #6366f1 0%, #4f46e5 100%); color: white; padding: 15px 40px; text-decoration: none; border-radius: 8px; font-weight: bold; display: inline-block;">Ver Conversación</a>
        </div>
    </div>
    
    <div style="background: #f9fafb; padding: 20px; border-radius: 0 0 10px 10px; text-align: center; border: 1px solid #e5e7eb; border-top: none;">
        <p style="margin: 0; color: #6b7280; font-weight: bold;">Equipo {{app_name}}</p>
    </div>
</div>',
                'variables' => ['app_name', 'user_name', 'sender_name', 'message_preview', 'chat_url'],
            ],
            [
                'slug' => 'referral-active',
                'name' => 'Referido Activo',
                'subject' => '🎁 ¡Has ganado un bono por referido! - {{app_name}}',
                'body' => '<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;">
    <div style="background: linear-gradient(135deg, #8b5cf6 0%, #7c3aed 100%); padding: 30px; border-radius: 10px 10px 0 0; text-align: center;">
        <h1 style="color: white; margin: 0; font-size: 24px;">🎁 ¡Bono de Referido!</h1>
    </div>
    
    <div style="background: #ffffff; padding: 30px; border: 1px solid #e5e7eb;">
        <p style="font-size: 16px; color: #374151;">¡Felicidades <strong>{{user_name}}</strong>!</p>
        
        <p style="color: #6b7280;"><strong>{{referred_name}}</strong> se ha registrado usando tu código de referido.</p>
        
        <div style="background: #f5f3ff; padding: 20px; border-radius: 8px; margin: 20px 0; text-align: center; border-left: 4px solid #8b5cf6;">
            <p style="margin: 0; font-size: 24px; color: #7c3aed; font-weight: bold;">{{referral_bonus}}</p>
            <p style="margin: 5px 0 0 0; color: #6d28d9;">Han sido añadidos a tu wallet</p>
        </div>
        
        <div style="text-align: center; margin: 30px 0;">
            <a href="{{wallet_url}}" style="background: linear-gradient(135deg, #8b5cf6 0%, #7c3aed 100%); color: white; padding: 15px 40px; text-decoration: none; border-radius: 8px; font-weight: bold; display: inline-block;">Ver Mi Wallet</a>
        </div>
    </div>
    
    <div style="background: #f9fafb; padding: 20px; border-radius: 0 0 10px 10px; text-align: center; border: 1px solid #e5e7eb; border-top: none;">
        <p style="margin: 0; color: #6b7280; font-weight: bold;">Equipo {{app_name}}</p>
    </div>
</div>',
                'variables' => ['app_name', 'user_name', 'referred_name', 'referral_bonus', 'wallet_url'],
            ],
            [
                'slug' => 'coach-plan-expired',
                'name' => 'Plan de Coach Expirado',
                'subject' => '⏰ Tu plan ha expirado - {{app_name}}',
                'body' => '<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;">
    <div style="background: linear-gradient(135deg, #6b7280 0%, #4b5563 100%); padding: 30px; border-radius: 10px 10px 0 0; text-align: center;">
        <h1 style="color: white; margin: 0; font-size: 24px;">⏰ Plan Expirado</h1>
    </div>
    
    <div style="background: #ffffff; padding: 30px; border: 1px solid #e5e7eb;">
        <p style="font-size: 16px; color: #374151;">Hola <strong>{{buyer_name}}</strong>,</p>
        
        <p style="color: #6b7280;">Tu plan <strong>{{plan_name}}</strong> con el coach <strong>{{coach_name}}</strong> ha expirado.</p>
        
        <div style="background: #f3f4f6; padding: 20px; border-radius: 8px; margin: 20px 0;">
            <p style="margin: 0; color: #374151;">Si deseas continuar con tu entrenamiento, puedes renovar tu plan.</p>
        </div>
        
        <div style="text-align: center; margin: 30px 0;">
            <a href="{{renew_url}}" style="background: linear-gradient(135deg, #10b981 0%, #059669 100%); color: white; padding: 15px 40px; text-decoration: none; border-radius: 8px; font-weight: bold; display: inline-block;">Renovar Plan</a>
        </div>
    </div>
    
    <div style="background: #f9fafb; padding: 20px; border-radius: 0 0 10px 10px; text-align: center; border: 1px solid #e5e7eb; border-top: none;">
        <p style="margin: 0; color: #6b7280; font-weight: bold;">Equipo {{app_name}}</p>
    </div>
</div>',
                'variables' => ['app_name', 'buyer_name', 'plan_name', 'coach_name', 'renew_url'],
            ],
            [
                'slug' => 'coach-plan-expiring',
                'name' => 'Plan de Coach por Expirar',
                'subject' => '⚠️ Tu plan expira en {{days_remaining}} días - {{app_name}}',
                'body' => '<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;">
    <div style="background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); padding: 30px; border-radius: 10px 10px 0 0; text-align: center;">
        <h1 style="color: white; margin: 0; font-size: 24px;">⚠️ Tu Plan Expira Pronto</h1>
    </div>
    
    <div style="background: #ffffff; padding: 30px; border: 1px solid #e5e7eb;">
        <p style="font-size: 16px; color: #374151;">¡Hola <strong>{{buyer_name}}</strong>!</p>
        
        <p style="color: #6b7280;">Tu plan <strong>{{plan_name}}</strong> expirará el <strong>{{ends_at}}</strong>.</p>
        
        <div style="background: #fef3c7; padding: 20px; border-radius: 8px; margin: 20px 0; border-left: 4px solid #f59e0b;">
            <p style="margin: 0; color: #92400e;">⏰ Quedan <strong>{{days_remaining}} días</strong></p>
        </div>
        
        <p style="color: #6b7280;">Renueva ahora para no perder acceso a tus rutinas y planes de alimentación.</p>
        
        <div style="text-align: center; margin: 30px 0;">
            <a href="{{renew_url}}" style="background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); color: white; padding: 15px 40px; text-decoration: none; border-radius: 8px; font-weight: bold; display: inline-block;">Renovar Ahora</a>
        </div>
    </div>
    
    <div style="background: #f9fafb; padding: 20px; border-radius: 0 0 10px 10px; text-align: center; border: 1px solid #e5e7eb; border-top: none;">
        <p style="margin: 0; color: #6b7280; font-weight: bold;">Equipo {{app_name}}</p>
    </div>
</div>',
                'variables' => ['app_name', 'buyer_name', 'plan_name', 'ends_at', 'days_remaining', 'renew_url'],
            ],
            [
                'slug' => 'meal-plan-assigned',
                'name' => 'Plan de Alimentación Asignado',
                'subject' => '🥗 Nuevo Plan de Alimentación - {{app_name}}',
                'body' => '<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;">
    <div style="background: linear-gradient(135deg, #22c55e 0%, #16a34a 100%); padding: 30px; border-radius: 10px 10px 0 0; text-align: center;">
        <h1 style="color: white; margin: 0; font-size: 24px;">🥗 Nuevo Plan de Alimentación</h1>
    </div>
    
    <div style="background: #ffffff; padding: 30px; border: 1px solid #e5e7eb;">
        <p style="font-size: 16px; color: #374151;">¡Hola <strong>{{client_name}}</strong>!</p>
        
        <p style="color: #6b7280;">Tu entrenador <strong>{{coach_name}}</strong> te ha asignado un nuevo plan de alimentación.</p>
        
        <div style="background: #f0fdf4; padding: 20px; border-radius: 8px; margin: 20px 0; border-left: 4px solid #22c55e;">
            <p style="margin: 0; color: #166534; font-weight: bold;">📋 {{meal_plan_name}}</p>
        </div>
        
        <div style="text-align: center; margin: 30px 0;">
            <a href="{{meal_plan_url}}" style="background: linear-gradient(135deg, #22c55e 0%, #16a34a 100%); color: white; padding: 15px 40px; text-decoration: none; border-radius: 8px; font-weight: bold; display: inline-block;">Ver Mi Dieta</a>
        </div>
    </div>
    
    <div style="background: #f9fafb; padding: 20px; border-radius: 0 0 10px 10px; text-align: center; border: 1px solid #e5e7eb; border-top: none;">
        <p style="margin: 0; color: #6b7280; font-weight: bold;">Equipo {{app_name}}</p>
    </div>
</div>',
                'variables' => ['app_name', 'client_name', 'coach_name', 'meal_plan_name', 'meal_plan_url'],
            ],
            [
                'slug' => 'workout-assigned',
                'name' => 'Rutina Asignada',
                'subject' => '💪 Nueva Rutina de Entrenamiento - {{app_name}}',
                'body' => '<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;">
    <div style="background: linear-gradient(135deg, #f97316 0%, #ea580c 100%); padding: 30px; border-radius: 10px 10px 0 0; text-align: center;">
        <h1 style="color: white; margin: 0; font-size: 24px;">💪 Nueva Rutina</h1>
    </div>
    
    <div style="background: #ffffff; padding: 30px; border: 1px solid #e5e7eb;">
        <p style="font-size: 16px; color: #374151;">¡Hola <strong>{{client_name}}</strong>!</p>
        
        <p style="color: #6b7280;">Tu entrenador <strong>{{coach_name}}</strong> te ha asignado una nueva rutina de entrenamiento.</p>
        
        <div style="background: #fff7ed; padding: 20px; border-radius: 8px; margin: 20px 0; border-left: 4px solid #f97316;">
            <p style="margin: 0; color: #9a3412; font-weight: bold;">🏋️ {{workout_name}}</p>
        </div>
        
        <div style="text-align: center; margin: 30px 0;">
            <a href="{{workout_url}}" style="background: linear-gradient(135deg, #f97316 0%, #ea580c 100%); color: white; padding: 15px 40px; text-decoration: none; border-radius: 8px; font-weight: bold; display: inline-block;">Ver Mi Rutina</a>
        </div>
    </div>
    
    <div style="background: #f9fafb; padding: 20px; border-radius: 0 0 10px 10px; text-align: center; border: 1px solid #e5e7eb; border-top: none;">
        <p style="margin: 0; color: #6b7280; font-weight: bold;">Equipo {{app_name}}</p>
    </div>
</div>',
                'variables' => ['app_name', 'client_name', 'coach_name', 'workout_name', 'workout_url'],
            ],
        ];

        foreach ($templates as $template) {
            EmailTemplate::updateOrCreate(
                ['slug' => $template['slug']],
                $template
            );
        }
    }
}
