<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Plan de Alimentación - {{ $client->name }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '{{ $settings["primary_color"] ?? "#10b981" }}',
                        secondary: '{{ $settings["secondary_color"] ?? "#059669" }}',
                        accent: '{{ $settings["accent_color"] ?? "#3b82f6" }}',
                    }
                }
            }
        }
    </script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap');
        
        * {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
        }
        
        @page {
            size: A4;
            margin: 0;
        }
        
        body {
            -webkit-print-color-adjust: exact !important;
            print-color-adjust: exact !important;
        }
        
        .page-break {
            page-break-after: always;
        }
        
        .avoid-break {
            page-break-inside: avoid;
        }
        
        .gradient-primary {
            background: linear-gradient(135deg, {{ $settings['primary_color'] ?? '#10b981' }}, {{ $settings['secondary_color'] ?? '#059669' }});
        }
        
        .gradient-accent {
            background: linear-gradient(135deg, {{ $settings['accent_color'] ?? '#3b82f6' }}, #6366f1);
        }
        
        .meal-icon {
            width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 12px;
            font-size: 20px;
        }
    </style>
</head>
<body class="bg-gray-50">
    <!-- Header -->
    <div class="gradient-primary text-white px-8 py-6">
        <div class="flex items-center justify-between">
            <div class="flex items-center gap-4">
                @if(isset($settings['logo']) && $settings['logo'])
                    <img src="{{ asset('storage/' . $settings['logo']) }}" alt="Logo" class="h-12 rounded-lg bg-white/20 p-1">
                @endif
                <div>
                    <h1 class="text-2xl font-bold">{{ $settings['site_name'] ?? 'CoachPro' }}</h1>
                    <p class="text-white/80 text-sm">Plan de Alimentación Personalizado</p>
                </div>
            </div>
            <div class="text-right">
                <p class="text-white/80 text-sm">Fecha de emisión</p>
                <p class="font-semibold">{{ now()->format('d/m/Y') }}</p>
            </div>
        </div>
    </div>

    <div class="px-8 py-6">
        <!-- Client Info Card -->
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6 mb-6">
            <div class="flex items-start justify-between">
                <div class="flex items-center gap-4">
                    <div class="w-16 h-16 rounded-full gradient-primary flex items-center justify-center text-white text-2xl font-bold">
                        {{ strtoupper(substr($client->name, 0, 1)) }}
                    </div>
                    <div>
                        <h2 class="text-xl font-bold text-gray-900">{{ $client->name }}</h2>
                        <p class="text-gray-500 text-sm">{{ $client->email ?? '' }}</p>
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-green-100 text-green-700 mt-2">
                            ✓ Plan Activo
                        </span>
                    </div>
                </div>
                <div class="text-right">
                    <p class="text-sm text-gray-500">Plan</p>
                    <p class="font-bold text-lg text-gray-900">{{ $mealPlan->name }}</p>
                </div>
            </div>
        </div>

        <!-- Stats Grid -->
        <div class="grid grid-cols-4 gap-4 mb-6">
            <!-- Calories -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-4 text-center">
                <div class="w-12 h-12 mx-auto mb-2 rounded-xl bg-orange-100 flex items-center justify-center">
                    <span class="text-2xl">🔥</span>
                </div>
                <p class="text-2xl font-bold text-gray-900">{{ number_format($totals['calories'], 0) }}</p>
                <p class="text-xs text-gray-500 uppercase tracking-wide">Calorías</p>
            </div>
            
            <!-- Proteins -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-4 text-center">
                <div class="w-12 h-12 mx-auto mb-2 rounded-xl bg-red-100 flex items-center justify-center">
                    <span class="text-2xl">🥩</span>
                </div>
                <p class="text-2xl font-bold text-gray-900">{{ number_format($totals['proteins'], 0) }}g</p>
                <p class="text-xs text-gray-500 uppercase tracking-wide">Proteínas</p>
            </div>
            
            <!-- Carbs -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-4 text-center">
                <div class="w-12 h-12 mx-auto mb-2 rounded-xl bg-amber-100 flex items-center justify-center">
                    <span class="text-2xl">🍞</span>
                </div>
                <p class="text-2xl font-bold text-gray-900">{{ number_format($totals['carbs'], 0) }}g</p>
                <p class="text-xs text-gray-500 uppercase tracking-wide">Carbohidratos</p>
            </div>
            
            <!-- Fats -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-4 text-center">
                <div class="w-12 h-12 mx-auto mb-2 rounded-xl bg-green-100 flex items-center justify-center">
                    <span class="text-2xl">🥑</span>
                </div>
                <p class="text-2xl font-bold text-gray-900">{{ number_format($totals['fats'], 0) }}g</p>
                <p class="text-xs text-gray-500 uppercase tracking-wide">Grasas</p>
            </div>
        </div>

        <!-- Macro Distribution -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-4 mb-6">
            <h3 class="font-semibold text-gray-700 mb-3 text-sm">Distribución de Macros</h3>
            @php
                $totalMacros = $totals['proteins'] + $totals['carbs'] + $totals['fats'];
                $proteinPct = $totalMacros > 0 ? round(($totals['proteins'] / $totalMacros) * 100) : 0;
                $carbsPct = $totalMacros > 0 ? round(($totals['carbs'] / $totalMacros) * 100) : 0;
                $fatsPct = $totalMacros > 0 ? round(($totals['fats'] / $totalMacros) * 100) : 0;
            @endphp
            <div class="flex gap-1 h-4 rounded-full overflow-hidden">
                <div class="bg-red-500" style="width: {{ $proteinPct }}%"></div>
                <div class="bg-amber-500" style="width: {{ $carbsPct }}%"></div>
                <div class="bg-green-500" style="width: {{ $fatsPct }}%"></div>
            </div>
            <div class="flex justify-between mt-2 text-xs text-gray-600">
                <span class="flex items-center gap-1"><span class="w-3 h-3 rounded bg-red-500"></span> Proteínas {{ $proteinPct }}%</span>
                <span class="flex items-center gap-1"><span class="w-3 h-3 rounded bg-amber-500"></span> Carbos {{ $carbsPct }}%</span>
                <span class="flex items-center gap-1"><span class="w-3 h-3 rounded bg-green-500"></span> Grasas {{ $fatsPct }}%</span>
            </div>
        </div>

        <!-- Diet Plans -->
        @foreach($dietPlans as $index => $dietPlan)
            <div class="avoid-break mb-6">
                <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
                    <!-- Diet Plan Header -->
                    <div class="gradient-primary px-6 py-4">
                        <div class="flex items-center justify-between">
                            <div class="flex items-center gap-3">
                                @php
                                    $mealIcons = [
                                        'breakfast' => '🌅',
                                        'mid_morning_snack' => '🍎',
                                        'lunch' => '🍽️',
                                        'mid_afternoon_snack' => '🥤',
                                        'dinner' => '🌙',
                                        'snack' => '🥜',
                                        'pre_workout' => '💪',
                                        'post_workout' => '🥛',
                                    ];
                                    $icon = $mealIcons[$dietPlan->meal_type] ?? '🍴';
                                @endphp
                                <span class="text-3xl">{{ $icon }}</span>
                                <div>
                                    <h3 class="text-white font-bold text-lg">{{ $mealLabels[$dietPlan->meal_type] ?? $dietPlan->meal_type }}</h3>
                                    @if($dietPlan->time)
                                        <p class="text-white/80 text-sm">🕐 {{ $dietPlan->time }}</p>
                                    @endif
                                </div>
                            </div>
                            @php
                                $planCals = 0;
                                foreach($dietPlan->items as $item) {
                                    $mult = ($item->quantity ?? 100) / 100;
                                    $planCals += ($item->calories ?: ($item->food->calories ?? 0)) * $mult;
                                }
                            @endphp
                            <div class="bg-white/20 rounded-lg px-4 py-2 text-white">
                                <span class="font-bold text-xl">{{ number_format($planCals, 0) }}</span>
                                <span class="text-sm"> kcal</span>
                            </div>
                        </div>
                    </div>

                    <!-- Food Items -->
                    <div class="p-4">
                        <table class="w-full">
                            <thead>
                                <tr class="text-left text-xs text-gray-500 uppercase tracking-wider">
                                    <th class="pb-3 font-medium">Alimento</th>
                                    <th class="pb-3 font-medium text-center">Cantidad</th>
                                    <th class="pb-3 font-medium text-center">Prot.</th>
                                    <th class="pb-3 font-medium text-center">Carbs</th>
                                    <th class="pb-3 font-medium text-center">Grasas</th>
                                    <th class="pb-3 font-medium text-right">Kcal</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-100">
                                @foreach($dietPlan->items as $item)
                                    @php
                                        $mult = ($item->quantity ?? 100) / 100;
                                        $itemCals = ($item->calories ?: ($item->food->calories ?? 0)) * $mult;
                                        $itemProt = ($item->proteins ?: ($item->food->proteins ?? 0)) * $mult;
                                        $itemCarbs = ($item->carbs ?: ($item->food->carbs ?? 0)) * $mult;
                                        $itemFats = ($item->fats ?: ($item->food->fats ?? 0)) * $mult;
                                    @endphp
                                    <tr class="hover:bg-gray-50">
                                        <td class="py-3">
                                            <div class="flex items-center gap-3">
                                                <div class="w-10 h-10 rounded-lg bg-gray-100 flex items-center justify-center text-lg">
                                                    {{ $item->food->emoji ?? '🍽️' }}
                                                </div>
                                                <div>
                                                    <p class="font-medium text-gray-900">{{ $item->food->name ?? $item->name ?? 'Alimento' }}</p>
                                                    @if($item->notes)
                                                        <p class="text-xs text-gray-500">{{ $item->notes }}</p>
                                                    @endif
                                                </div>
                                            </div>
                                        </td>
                                        <td class="py-3 text-center">
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-800">
                                                {{ $item->quantity ?? 100 }}g
                                            </span>
                                        </td>
                                        <td class="py-3 text-center text-sm text-red-600 font-medium">{{ number_format($itemProt, 1) }}g</td>
                                        <td class="py-3 text-center text-sm text-amber-600 font-medium">{{ number_format($itemCarbs, 1) }}g</td>
                                        <td class="py-3 text-center text-sm text-green-600 font-medium">{{ number_format($itemFats, 1) }}g</td>
                                        <td class="py-3 text-right">
                                            <span class="font-bold text-gray-900">{{ number_format($itemCals, 0) }}</span>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    @if($dietPlan->notes)
                        <div class="px-4 pb-4">
                            <div class="bg-amber-50 border border-amber-200 rounded-lg p-3">
                                <p class="text-sm text-amber-800">
                                    <span class="font-semibold">💡 Nota:</span> {{ $dietPlan->notes }}
                                </p>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        @endforeach

        <!-- General Notes -->
        @if($mealPlan->notes)
            <div class="bg-gradient-to-r from-blue-50 to-indigo-50 rounded-xl border border-blue-200 p-5 mb-6">
                <h3 class="font-bold text-blue-900 mb-2 flex items-center gap-2">
                    <span>📋</span> Notas Generales
                </h3>
                <p class="text-blue-800 text-sm leading-relaxed">{{ $mealPlan->notes }}</p>
            </div>
        @endif

        <!-- Coach Info -->
        @if(!empty($coach) && ($settings['show_coach_info'] ?? true))
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-5">
                <div class="flex items-center gap-4">
                    @if(!empty($coach['photo']))
                        <img src="{{ $coach['photo'] }}" alt="{{ $coach['name'] }}" class="w-14 h-14 rounded-full object-cover">
                    @else
                        <div class="w-14 h-14 rounded-full gradient-accent flex items-center justify-center text-white font-bold text-xl">
                            {{ strtoupper(substr($coach['name'] ?? 'C', 0, 1)) }}
                        </div>
                    @endif
                    <div>
                        <p class="text-sm text-gray-500">Tu Entrenador</p>
                        <p class="font-bold text-gray-900">{{ $coach['name'] ?? '' }}</p>
                        <p class="text-sm text-gray-600">{{ $coach['email'] ?? '' }}</p>
                    </div>
                </div>
            </div>
        @endif
    </div>

    <!-- Footer -->
    <div class="fixed bottom-0 left-0 right-0 bg-gray-100 px-8 py-3 border-t border-gray-200">
        <div class="flex items-center justify-between text-xs text-gray-500">
            <p>{{ $settings['site_name'] ?? 'CoachPro' }} - Plan de Alimentación</p>
            <p>Generado el {{ now()->format('d/m/Y H:i') }}</p>
        </div>
    </div>
</body>
</html>
