<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
*/

Route::middleware('auth:sanctum')->group(function () {
    // Chat typing indicator
    Route::post('/chat/typing', function (Request $request) {
        $validated = $request->validate([
            'receiver_id' => 'required|integer',
            'coach_id' => 'nullable|integer',
            'client_id' => 'nullable|integer',
            'admin_id' => 'nullable|integer',
        ]);

        // Determine channel name
        $channelName = null;
        if ($validated['admin_id'] && $validated['coach_id']) {
            $channelName = "admin-chat.{$validated['admin_id']}.{$validated['coach_id']}";
        } elseif ($validated['coach_id'] && $validated['client_id']) {
            $channelName = "chat.{$validated['coach_id']}.{$validated['client_id']}";
        }

        if ($channelName && class_exists('\Illuminate\Support\Facades\Broadcast')) {
            // Whisper typing event to the channel
            try {
                broadcast(new \App\Events\UserTyping(
                    $request->user()->id,
                    $request->user()->name,
                    $validated['coach_id'],
                    $validated['client_id'],
                    $validated['admin_id']
                ))->toOthers();
            } catch (\Exception $e) {
                // Silently fail if broadcasting fails
            }
        }

        return response()->json(['success' => true]);
    });
});
